unit Dat;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;
                  
type
  TLWSetup = class(TForm)
    Lw5: TEdit;
    Lw6: TEdit;
    Lw1: TEdit;
    Lw2: TEdit;
    Lw3: TEdit;
    Lw4: TEdit;
    GroupBox1: TGroupBox;
    RadioButton2: TRadioButton;
    RadioButton1: TRadioButton;
    RadioButton3: TRadioButton;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    WSNR: TEdit;
    LW99: TEdit;
    Bevel1: TBevel;
    Label3: TLabel;
    PW: TEdit;
    Label6: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Sprachgroup: TGroupBox;
    DRadio: TRadioButton;
    ERadio: TRadioButton;

    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DRadioClick(Sender: TObject);
    procedure ERadioClick(Sender: TObject);
    procedure Label4DblClick(Sender: TObject);
  private
    Procedure Setze_Sprache;
  public
    { Public-Deklarationen }
  end;

var
  LWSetup: TLWSetup;
  Treiber     : String[8];
  __Laufwerk  : String[60];
  __Laufwerk2 : String[60];
  __Laufwerk3 : String[60];
  __Laufwerk4 : String[60];
  __Laufwerk5 : String[60];
  __Laufwerk6 : String[60];
  __Netz      : String[20];
  IsamWsnr    : String;
  __LST       : Text;
  _PW         : String[10];
  {NetType     : NetSupportType;}
  HomeDir     : STring;
  AName1, AName2, AStrasse, APlzOrt,
  aBank, aKonto, aBlz : String[60];
  DruckerIndex : Integer;

  Function GetAppName: String;

implementation

{$R *.DFM}

Uses UToolDll, IniFiles, Dat2;

Var DatIni: TIniFile;

Function Encode_Pw(Pw: String): String;
var s,t: String;
    ix,i,x: Integer;
begin
  S:= '';
  if Length(Pw) > 0 then begin
    ix:= 0;
    for i:= 1 to length(pw) do begin
      inc(ix); if ix > 3 then ix:= 1;
      {if pw[i] = '' then pw[i]:= '';
      if pw[i] = '' then pw[i]:= '';
      if pw[i] = '' then pw[i]:= '';}
      x:= 255 - ord(pw[i]) - ix;
      Str(x,t);
      While Length(T) < 3 do T:= '0'+T;
      S:= S + T;
    end;
  end;
  Result:= S;
end;

Function Encrypted(Pw: String): Boolean;
var e: Boolean;
    i: Integer;
begin
  E:= True;
  if Length(Pw) > 0 then begin
    i:= 1;
    While (i <= Length(Pw)) and (E = True) do begin
      if not(pw[i] in ['0'..'9']) then E:= False
      else Inc(i);
    end;
  end;
  Result:= E;
end;

Function Decode_Pw(Pw: String): String;
var p,s,t: String;
    ix,i,C,x,Code: Integer;
begin
  if EnCrypted(Pw) = False then S:= Pw
  else begin
    s:= '';
    P:= Pw;
    i:= 0;
    ix:= 0;
    While Length(P) > 0 do begin
      inc(ix); if ix > 3 then ix:= 1;
      inc(i);
      t:= Copy(P,1,3);
      Val(T,x,Code);
      C:= (255 -x -ix);
      if (C > 0) and (C < 256) then S:= S + Chr(C);
      Delete(P,1,3);
    end;
  end;
  Result:= S;
end;

Function GetAppName: String;
var G: String;
    xPos: Integer;
begin
  G:= Application.ExeName;
  xPos:= Pos('\',G);
  While xPos > 0 do begin
    Delete(G,1,xPos);
    xPos:= Pos('\',G);
  end;
  xPos:= Pos('.',G);
  if xPos > 0 then G:= Copy(G,1,xPos-1);
  GetAppName:= G;
end;

procedure TLWSetup.FormShow(Sender: TObject);
begin
  Caption := 'Setup  '+ HomeDir + 'DATEIEN.INI';
end;

procedure TLWSetup.FormCreate(Sender: TObject);
begin
  HomeDir:= ExtractFilePath(Application.ExeName);
  DatIni:= TIniFile.Create(HomeDir + 'DATEIEN.INI');
  __Laufwerk:= DatIni.ReadString('DAT_SETUP','Laufwerk1',HomeDir);
  __Laufwerk2:= DatIni.ReadString('DAT_SETUP','Laufwerk2','');
  __Laufwerk3:= DatIni.ReadString('DAT_SETUP','Laufwerk3','');
  __Laufwerk4:= DatIni.ReadString('DAT_SETUP','Laufwerk4','');
  __Laufwerk5:= DatIni.ReadString('DAT_SETUP','Laufwerk5','');
  __Laufwerk6:= DatIni.ReadString('DAT_SETUP','Laufwerk6','');
  __Netz:= DatIni.ReadString('DAT_SETUP','Netz','');
  IsamWsnr:= DatIni.ReadString('DAT_SETUP','ISAMWSNR','');
  _PW:= Decode_PW(DatIni.ReadString('DAT_SETUP','PW',''));
  Sprache:= DatIni.ReadInteger('DAT_SETUP','Sprache',0);
  DruckerIndex:= DatIni.ReadInteger('DAT_SETUP','Drucker',-1);
  if Sprache <> 1 then Sprache:= 0;
  if Sprache = 1 then ERadio.Checked:= True else DRadio.Checked:= True;

  AName1:= Decode_PW(DatIni.ReadString('ANWENDER','NAME1',''));
  AName2:= Decode_PW(DatIni.ReadString('ANWENDER','NAME2',''));
  AStrasse:= Decode_PW(DatIni.ReadString('ANWENDER','STRASSE',''));
  APlzOrt := Decode_PW(DatIni.ReadString('ANWENDER','PLZORT',''));
  aBank   := DatIni.ReadString('ANWENDER','BANK','');
  aKonto  := DatIni.ReadString('ANWENDER','KONTO','');
  aBlz    := DatIni.ReadString('ANWENDER','BLZ','');

  DatIni.Free;
  Setze_Sprache;
  {if __Netz = '' then __Netz := 'NONET';}

  LW1.Text      := __Laufwerk;
  LW2.Text      := __Laufwerk2;
  LW3.Text      := __Laufwerk3;
  LW4.Text      := __Laufwerk4;
  LW5.Text      := __Laufwerk5;
  LW6.Text      := __Laufwerk6;
  LW99.Text     := HomeDir;
  PW.Text       := _PW;
  if Upstr(__Netz) = 'NONET' then Radiobutton1.Checked := True;
  if Upstr(__Netz) = 'MSNET' then Radiobutton2.Checked := True;
  if Upstr(__Netz) = 'NOVELLNET' then Radiobutton3.Checked := True;
  Wsnr.Text := IsamWsNR;
end;

Procedure TLWSetup.Setze_Sprache;
begin
  if Sprache = 1 then begin
    Groupbox1.Caption:= 'Net';
    Label6.Caption:= 'Password';
    SprachGroup.Caption:= 'Language';
    DRadio.Caption:= 'German';
    ERadio.Caption:= 'English';
  end
  else begin
    Groupbox1.Caption:= 'Netz';
    Label6.Caption:= 'Passwort';
    SprachGroup.Caption:= 'Sprache';
    DRadio.Caption:= 'Deutsch';
    ERadio.Caption:= 'Englisch';
  end;
end;

procedure TLWSetup.BitBtn1Click(Sender: TObject);
var xStr: String;
begin
  __Laufwerk :=LW1.Text;
  __Laufwerk2:=LW2.Text;
  __Laufwerk3:=LW3.Text;
  __Laufwerk4:=LW4.Text;
  __Laufwerk5:=LW5.Text;
  __Laufwerk6:=LW6.Text;
  _PW := PW.Text;
  IsamWsnr:= Wsnr.Text;
  if DRadio.Checked then Sprache:= 0 else Sprache:= 1;
  if Radiobutton1.Checked then
  begin
    __Netz := 'NONET';
    {NetType := NoNet;}
  end;
  if Radiobutton2.Checked then
  begin
    __Netz := 'MSNET';
    {NetType := MsNet;}
  end;
  if Radiobutton3.Checked then
  begin
    __Netz := 'NOVELLNET';
    {NetType := Novell;}
  end;
  HomeDir:= ExtractFilePath(Application.ExeName);
  DatIni:= TIniFile.Create(HomeDir + 'DATEIEN.INI');
  DatIni.WriteString('DAT_SETUP','Laufwerk1',__Laufwerk);
  DatIni.WriteString('DAT_SETUP','Laufwerk2',__Laufwerk2);
  DatIni.WriteString('DAT_SETUP','Laufwerk3',__Laufwerk3);
  DatIni.WriteString('DAT_SETUP','Laufwerk4',__Laufwerk4);
  DatIni.WriteString('DAT_SETUP','Laufwerk5',__Laufwerk5);
  DatIni.WriteString('DAT_SETUP','Laufwerk6',__Laufwerk6);
  DatIni.WriteString('DAT_SETUP','Netz',__Netz);
  DatIni.WriteString('DAT_SETUP','ISAMWSNR',IsamWsnr);
  xstr:= Encode_Pw(_PW);
  DatIni.WriteString('DAT_SETUP','PW',xStr);
  DatIni.WriteInteger('DAT_SETUP','Sprache',Sprache);
  xStr:= Encode_PW(aName1);
  DatIni.WriteString('ANWENDER','NAME1',xStr);
  xStr:= Encode_PW(aName2);
  DatIni.WriteString('ANWENDER','NAME2',xStr);
  xStr:= Encode_PW(aStrasse);
  DatIni.WriteString('ANWENDER','STRASSE',xStr);
  xStr:= Encode_PW(aPlzOrt);
  DatIni.WriteString('ANWENDER','PLZORT',xStr);
  DatIni.WriteString('ANWENDER','BANK',aBank);
  DatIni.WriteString('ANWENDER','KONTO',aKonto);
  DatIni.WriteString('ANWENDER','BLZ',aBlz);
  DatIni.Free;
  Close;
end;

procedure TLWSetup.DRadioClick(Sender: TObject);
begin
  if DRadio.Checked then Sprache:= 0 else Sprache:= 1;
  Setze_Sprache;
end;

procedure TLWSetup.ERadioClick(Sender: TObject);
begin
  if ERadio.Checked then Sprache:= 1 else Sprache:= 0;
  Setze_Sprache;
end;

procedure TLWSetup.Label4DblClick(Sender: TObject);
var xStr: String;
begin
  if Password('070746') then begin
    AnwDlg:= TAnwDlg.Create(Self);
    Try
      AnwDlg.Name1Edit.Text:= AName1;
      AnwDlg.NAME2Edit.Text:= AName2;
      AnwDlg.STRASSEEdit.Text:= aStrasse;
      AnwDlg.PLZORTEdit.Text:= aPlzOrt;
      AnwDlg.BANKEdit.Text:= aBank;
      AnwDlg.KONTOEdit.Text:= aKonto;
      AnwDlg.BLZEdit.Text:= aBlz;
      if AnwDlg.ShowModal = mrOk then begin
        AName1:= AnwDlg.Name1Edit.Text;
        AName2:= AnwDlg.NAME2Edit.Text;
        AStrasse:= AnwDlg.STRASSEEdit.Text;
        APlzOrt := AnwDlg.PLZORTEdit.Text;
        aBank   := AnwDlg.BANKEdit.Text;
        aKonto  := AnwDlg.KONTOEdit.Text;
        aBlz    := AnwDlg.BLZEdit.Text;
        HomeDir:= ExtractFilePath(Application.ExeName);
        DatIni:= TIniFile.Create(HomeDir + 'DATEIEN.INI');
        xStr:= Encode_PW(aName1);
        DatIni.WriteString('ANWENDER','NAME1',xStr);
        xStr:= Encode_PW(aName2);
        DatIni.WriteString('ANWENDER','NAME2',xStr);
        xStr:= Encode_PW(aStrasse);
        DatIni.WriteString('ANWENDER','STRASSE',xStr);
        xStr:= Encode_PW(aPlzOrt);
        DatIni.WriteString('ANWENDER','PLZORT',xStr);
        DatIni.WriteString('ANWENDER','BANK',aBank);
        DatIni.WriteString('ANWENDER','KONTO',aKonto);
        DatIni.WriteString('ANWENDER','BLZ',aBlz);
        DatIni.Free;
      end;
    Finally
      AnwDlg.Free;
    End;
  end;
end;

{Unit Initialisation}
begin
  HomeDir:= ExtractFilePath(Application.ExeName);
  DatIni:= TIniFile.Create(HomeDir + 'DATEIEN.INI');
  __Laufwerk:= DatIni.ReadString('DAT_SETUP','Laufwerk1',HomeDir);
  __Laufwerk2:= DatIni.ReadString('DAT_SETUP','Laufwerk2','');
  __Laufwerk3:= DatIni.ReadString('DAT_SETUP','Laufwerk3','');
  __Laufwerk4:= DatIni.ReadString('DAT_SETUP','Laufwerk4','');
  __Laufwerk5:= DatIni.ReadString('DAT_SETUP','Laufwerk5','');
  __Laufwerk6:= DatIni.ReadString('DAT_SETUP','Laufwerk6','');
  __Netz:= DatIni.ReadString('DAT_SETUP','Netz','');
  IsamWsnr:= DatIni.ReadString('DAT_SETUP','ISAMWSNR','');
  _PW:= Decode_Pw(DatIni.ReadString('DAT_SETUP','PW',''));
  Sprache:= DatIni.ReadInteger('DAT_SETUP','Sprache',0);
  DruckerIndex:= DatIni.ReadInteger('DAT_SETUP','Drucker',-1);
  if Sprache <> 1 then Sprache:= 0;
  AName1:= Decode_PW(DatIni.ReadString('ANWENDER','NAME1',''));
  AName2:= Decode_PW(DatIni.ReadString('ANWENDER','NAME2',''));
  AStrasse:= Decode_PW(DatIni.ReadString('ANWENDER','STRASSE',''));
  APlzOrt := Decode_PW(DatIni.ReadString('ANWENDER','PLZORT',''));
  aBank   := DatIni.ReadString('ANWENDER','BANK','');
  aKonto  := DatIni.ReadString('ANWENDER','KONTO','');
  aBlz    := DatIni.ReadString('ANWENDER','BLZ','');
  DatIni.Free;
end.

